---
description: "Learn more about: List.TransformMany"
title: "List.TransformMany"
---
# List.TransformMany

## Syntax

<pre>
List.TransformMany(<b>list</b> as list, <b>collectionTransform</b> as function, <b>resultTransform</b> as function) as list
</pre>

## About

Returns a list whose elements are projected from the input list.

The `collectionTransform` function transforms each element into an intermediate list, and the `resultTransform` function receives the original element as well as an item from the intermediate list in order to construct the final result.

The `collectionTransform` function has the signature `(x as any) as list => ...`, where `x` is an element in `list`. The `resultTransform` function projects the shape of the result and has the signature `(x as any, y as any) as any => ...`, where `x` is an element in `list` and `y` is an element from the list generated by passing `x` to `collectionTransform`.

## Example 1

Flatten a list of people and their pets.

**Usage**

```powerquery-m
List.TransformMany(
    {
        [Name = "Alice", Pets = {"Scruffy", "Sam"}],
        [Name = "Bob", Pets = {"Walker"}]
    },
    each [Pets],
    (person, pet) => [Name = person[Name], Pet = pet]
)
```

**Output**

```powerquery-m
{
    [Name = "Alice", Pet = "Scruffy"],
    [Name = "Alice", Pet = "Sam"],
    [Name = "Bob", Pet = "Walker"]
}
```
